#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <cmath>

double util(int us, int mov, FILE *u, FILE *m) {

	int user, movie, rating;
	int cur_mov;
	int i,j;
	int cur_pos;
	char *buf;
	char gen_list[20];
	double num, denom1, denom2, denom, wis, wic, ut;
	rewind(u);
	rewind(m);
	buf = (char *)malloc(sizeof(char)*1000);
	num=denom1=denom2=0;

	do {
		memset(buf, 0, 1000);
		cur_pos = ftell(u);
		fgets(buf, 1000, u);
		sscanf(buf, "%d", &user);
	} while(user!=us);

	for(j=0;j<mov;j++)
		fscanf(m, "%s\n", gen_list);


	fseek(u, cur_pos, SEEK_SET);
	fscanf(u, "%d", &user);
	for(i=0; i<18; i++) {
		fscanf(u, "%lf", &wic);
		wis = (double)(gen_list[i]-'0');
		num += wic*wis;
		denom1 += wic*wic;
		denom2 += wis*wis;
	}

	denom1 = sqrtl(denom1);
	denom2 = sqrtl(denom2);
	if(denom1==0) return 0.0;
	ut = 5*num/(denom1*denom2);

	return ut;
}

int main() {
	double ut; 
	FILE *u, *m;
	double mae;
	double mae_list[50000];
	double error;
	double cal_util;
	int mov_n=0;
	int i;
	int cur_user, movie, rating;
	FILE *test;
	FILE *result;

	u = fopen("uProfiles.dat", "r");
	m = fopen("movieGenre.dat", "r");
	test = fopen("test.dat", "r");
	result = fopen("result.dat", "w");
  
	mae = 0.0;
  double RMSE = 0.0d;
	do {
		fscanf(test, "%d%d%d\n", &cur_user, &movie, &rating);
		cal_util = util(cur_user, movie, u, m);
    if(std::isnan(cal_util))
    {
      fprintf(result, "%d %d %f\n", cur_user, movie, 0);
      continue;
    }
		mae_list[mov_n++] = fabsl(rating-cal_util);
		fprintf(result, "%d %d %f\n", cur_user, movie, cal_util);
    RMSE+=((rating-cal_util)*(rating-cal_util));
	} while(!feof(test));

	for(i=0; i<mov_n; i++) {
		mae += mae_list[i];
	}

  RMSE = sqrt(RMSE/mov_n);
  printf("\nRMSE:%lf\n",RMSE);
	printf("\n%d", mov_n);
	mae = mae/((mov_n));
	fprintf(result, "\nMAE:%f", mae);

	fclose(u); 
	fclose(m);
	fclose(test);
	fclose(result);

	return 0;
}